#ifndef CE2_ECPKI_ERROR_H
#define CE2_ECPKI_ERROR_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/
#include "CE2_error.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Mon Mar 05 15:00:40 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains contains error codes for ECC functions.
* 
* \version CE2_ECPKI_Error.h#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

  /* CE2_ECPKI_GenKeyPair() error codes */
#define CE2_ECPKI_GEN_KEY_ILLEGAL_DOMAIN_ID_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x01)
#define CE2_ECPKI_GEN_KEY_INVALID_PRIVATE_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x02)
#define CE2_ECPKI_GEN_KEY_INVALID_PUBLIC_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x03)

  /* CE2_ECPKI_BuildPrivKey() error codes */
#define CE2_ECPKI_BLD_PRIV_KEY_ILLEGAL_DOMAIN_ID_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x11)
#define CE2_ECPKI_BLD_PRIV_KEY_INVALID_PRIVATE_KEY_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x12)
#define CE2_ECPKI_BLD_PRIV_KEY_INVALID_PRIVATE_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x13)

  /* CE2_ECPKI_BuildPublKey() error codes */
#define CE2_ECPKI_BLD_PUBL_KEY_ILLEGAL_DOMAIN_ID_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x21)
#define CE2_ECPKI_BLD_PUBL_KEY_INVALID_PUBLIC_KEY_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x22)
#define CE2_ECPKI_BLD_PUBL_KEY_INVALID_PUBLIC_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x23)

  /* CE2_ECPKI_SVDP_DH() error codes */
#define CE2_ECPKI_SVDP_DH_INVALID_BUILDED_PARTNER_PUBLIC_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x31)
#define CE2_ECPKI_SVDP_DH_INVALID_USER_PRIVATE_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x32)
#define CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x33)
#define CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x34)
#define CE2_ECPKI_SVDP_DH_INVALID_DOMAIN_ID_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x35)
  /* LLF_ECPKI_SVDP_DH() error codes */
#define LLF_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_SIZE_ERROR (LLF_ECPKI_MODULE_ERROR_BASE + 0x31)

  /* CE2_ECDSA_Sign() error codes */
#define CE2_ECDSA_SIGN_INVALID_USER_PRIV_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x41)
#define CE2_ECDSA_SIGN_ILLEGAL_HASH_OP_MODE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x42)
#define CE2_ECDSA_SIGN_INVALID_MESSAGE_DATA_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x43)
#define CE2_ECDSA_SIGN_INVALID_SIGNATURE_OUT_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x44)
#define CE2_ECDSA_SIGN_INVALID_SIGNATURE_OUT_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x45)

  /* CE2_ECDSA_Verify() error codes */
#define CE2_ECDSA_VERIFY_INVALID_SIGNER_PUBL_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x51)
#define CE2_ECDSA_VERIFY_ILLEGAL_HASH_OP_MODE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x52)
#define CE2_ECDSA_VERIFY_INVALID_SIGNATURE_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x53)
#define CE2_ECDSA_VERIFY_INVALID_MESSAGE_DATA_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x54)

  /* _DX_ECPKI_ELGAMAL_Encrypt() error codes */
#define CE2_EC_ELGAMAL_ENCR_INVALID_RECEIVER_PUBL_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x61)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x62)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x63)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x64)
#define CE2_EC_ELGAMAL_ENCR_INVALID_EPHEMERAL_KEY_IN_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x65)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_IN_SIZE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x66)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_SIZE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x67)

  /* CE2_ECPKI_ELGAMAL_Decrypt */
#define CE2_EC_ELGAMAL_DECR_INVALID_RECEIVER_PRIV_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x71)
#define CE2_EC_ELGAMAL_DECR_INVALID_ENCR_MESSAGE_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x72)
#define CE2_EC_ELGAMAL_DECR_INVALID_DECR_MESSAGE_OUT_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x73)
#define CE2_EC_ELGAMAL_DECR_INVALID_DECR_MESSAGE_OUT_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x74)
#define CE2_EC_ELGAMAL_DECR_INVALID_ENCR_MESSAGE_IN_SIZE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x75)
#define CE2_EC_ELGAMAL_DECR_INVALID_ENCR_MESSAGE_OUT_SIZE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x76)

  /* CE2_ECPKI_ExportPublKey error codes */
#define CE2_ECPKI_EXPORT_PUBL_KEY_INVALID_USER_PUBL_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x81)
#define CE2_ECPKI_EXPORT_PUBL_KEY_ILLEGAL_COMPRESSION_MODE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x82)
#define CE2_ECPKI_EXPORT_PUBL_KEY_ILLEGAL_PUBL_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x83)
#define CE2_ECPKI_EXPORT_PUBL_KEY_ILLEGAL_PUBL_KEY_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x84)

  /* CE2_ECPKI_ExportKeyPair error codes */
#define CE2_ECPKI_EXPORT_KEY_PAIR_INVALID_USER_PRIV_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x91)
#define CE2_ECPKI_EXPORT_KEY_PAIR_ILLEGAL_KEY_PAIR_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x92)
#define CE2_ECPKI_EXPORT_KEY_PAIR_ILLEGAL_KEY_PAIR_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x93)
  /* LLF_ECPKI_ExportKeyPair error codes */
#define LLF_ECPKI_EXPORT_KEY_PAIR_INVALID_KEY_PAIR_SIZE_ERROR (LLF_ECPKI_MODULE_ERROR_BASE + 0x91)

  /* CE2_ECPKI_ExportPrivKey error codes */
#define CE2_ECPKI_EXPORT_PRIVATE_KEY_INVALID_USER_PRIV_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0xA1)
#define CE2_ECPKI_EXPORT_PRIVATE_KEY_INVALID_EXTERN_PRIVATE_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0xA2)
#define CE2_ECPKI_EXPORT_PRIVATE_KEY_INVALID_EXTERN_PRIVATE_KEY_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0xA3)
  /* LLF_ECPKI_ExportPrivKey error codes */
#define LLF_ECPKI_EXPORT_PRIVATE_KEY_INVALID_EXTERN_PRIVATE_KEY_SIZE_ERROR (LLF_ECPKI_MODULE_ERROR_BASE + 0xA1)

#ifdef __cplusplus
}
#endif

#endif /* CE2_ECPKI_ERROR_H */
